<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

// Title
class studiare_Widget_Customer_video extends Widget_Base {

   public function get_name() {
      return 'customer_video';
   }

   public function get_title() {
      return esc_html__( 'ویدئوی مشتریان', 'studiare-core' );
   }

   public function get_icon() {
        return 'eicon-testimonial';
   }

   public function get_categories() {
      return [ 'studiare-elements' ];
   }

   protected function register_controls() {

      $this->start_controls_section(
         'testimonials_section',
         [
            'label' => esc_html__( 'ویدئوی مشتریان', 'studiare-core' ),
            'type' => Controls_Manager::SECTION,
         ]
      );

      $repeater = new \Elementor\Repeater();

      $repeater->add_control(
         'image',
         [
            'label' => __( 'Choose Photo', 'studiare-core' ),
            'type' => \Elementor\Controls_Manager::MEDIA,
            'default' => [
               'url' => \Elementor\Utils::get_placeholder_image_src(),
            ],
         ]
      );

      $repeater->add_control(
         'name',
         [
            'label' => __( 'Name', 'studiare-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,

         ]
      );

      $repeater->add_control(
         'designation',
         [
            'label' => __( 'Designation', 'studiare-core' ),
            'type' => \Elementor\Controls_Manager::TEXT
         ]
      );

      $repeater->add_control(
         'video',
         [
            'label' => __( 'ویدئوی نظر مشتری', 'studiare-core' ),
            'type' => \Elementor\Controls_Manager::URL,
         ]
      );


      $this->add_control(
         'testimonial_list',
         [
            'label' => __( 'لیست ویدئو ها', 'studiare-core' ),
            'type' => \Elementor\Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'title_field' => '{{{name}}}',

         ]
      );
      
      $this->add_control(
			'video_color',
			[
				'label'     => esc_html__( 'رنگ گرادینت پس زمینه', 'studiare-core' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .image-box-item .customer-thumbnail::before ' => 'background: linear-gradient(180deg, rgba(0, 0, 0, 0) 0%, {{VALUE}} 83.41%, {{VALUE}} 100%)',
				],
			]
		);

      $this->add_control(
			'video_play_color',
			[
				'label'     => esc_html__( 'رنگ دکمه پلی ویدئو', 'studiare-core' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .image-box-item .customer-video ' => 'background: {{VALUE}}',
				],
			]
		);


      $this->end_controls_section();


      $this->start_controls_section(
         'testimonials__carousel_section',
         [
            'label' => esc_html__( 'تنظیمات کروسل', 'studiare-core' ),
            'type' => Controls_Manager::SECTION,
         ]
      );


      $this->add_control(
         'columns',
         [
            'label' => __( 'Columns', 'studiare-core' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'default' => '4',
            'options' => [
               '4' => __( '4 ستونه', 'studiare-core' ),
               '3' => __( '3 ستونه', 'studiare-core' ),
               '2' => __( '2 ستونه', 'studiare-core' ),
               '1' => __( '1 ستونه', 'studiare-core' ),
            ],
         ]
      );

      $this->add_control(
           'pagination',
           [
              'label' => __( 'صفحه گذاری اسلایدر', 'studiare-core' ),
              'type' => \Elementor\Controls_Manager::SWITCHER,
              'default' => 'yes',

           ]
        );

  	  $this->add_control(
           'navigation',
           [
              'label' => __( 'فلش های ناوبری', 'studiare-core' ),
              'type' => \Elementor\Controls_Manager::SWITCHER,
              'default' => 'yes',

           ]
        );

  	  $this->add_control(
           'loop',
           [
              'label' => __( 'حلقه کروسل', 'studiare-core' ),
              'type' => \Elementor\Controls_Manager::SWITCHER,
              'default' => 'yes',

           ]
        );

  	  $this->add_control(
           'autoplay',
           [
              'label' => __( 'اجرای خودکار اسلایدر', 'studiare-core' ),
              'type' => \Elementor\Controls_Manager::SWITCHER,
              'default' => 'yes',

           ]
        );


      $this->end_controls_section();


   }

   protected function render( $instance = [] ) {

      // get our input from the widget settings.
      $settings = $this->get_settings_for_display();
      $slider_data = array();
      $slider_data['data-slider-items'] = $settings['columns'];
      $slider_data['data-loop'] = $settings['loop'];
      $slider_data['data-pagination'] = $settings['pagination'];
      $slider_data['data-navigation'] = $settings['navigation'];
      $slider_data['data-autoplay'] = $settings['autoplay'];


      ?>

      <div class="testimonials-wrapper row align-items-center">
         <div class="testimonials-carousel owl-carousel" <?php echo studiare_get_inline_attrs( $slider_data ); ?>>
            <?php foreach (  $settings['testimonial_list'] as $testimonial_single ): ?>
               <div class="image-box-item">
                  <div class="customer-thumbnail">
                                <img src="<?php echo esc_url( $testimonial_single['image']['url'] ); ?>" alt="<?php echo esc_html($testimonial_single['name']); ?>">
                                <a class="customer-video" href="<?php echo esc_url($testimonial_single['video']['url']); ?>">
                                <i class="fas fa-play"></i>
								         </a>
                                <div class="customer-video-content">
                                    <h6 class="customer-title"><?php echo esc_html($testimonial_single['name']); ?></h6>
                                    <p><?php echo esc_html($testimonial_single['designation']); ?></p>
                                </div>
                  </div>
               </div>
            <?php endforeach; ?>
         </div>
      </div>

   <?php }

}

Plugin::instance()->widgets_manager->register( new studiare_Widget_Customer_video );
