<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

// search
class studiare_Widget_List_icon extends Widget_Base {

   public function get_name() {
      return 'listicon';
   }

   public function get_title() {
      return esc_html__( 'لیست آیکون', 'studiare-core' );
   }

   public function get_icon() {
        return 'eicon-editor-list-ul';
   }

   public function get_categories() {
      return [ 'studiare-elements' ];
   }

   protected function register_controls() {

	$this->start_controls_section(
		'general_content_section',
		array(
			'label' => esc_html__( 'عمومی', 'studiare-core' ),
		)
	);

	$repeater = new Repeater();

	$repeater->start_controls_tabs( 'list_items' );

	$repeater->start_controls_tab(
		'content_tab',
		array(
			'label' => esc_html__( 'محتوا', 'studiare-core' ),
			'tab'   => Controls_Manager::TAB_CONTENT,
		)
	);

	$repeater->add_control(
		'list_title',
		array(
			'label'   => esc_html__( 'عنوان', 'studiare-core' ),
			'type'    => Controls_Manager::TEXT,
			'default' => 'عنوان آکاردئون. برای ویرایش اینجا کلیک کنید.',
		)
	);

    $repeater->add_control(
        'icon',
        [
            'label'     => esc_html__( 'آیکون', 'studiare-core' ),
            'type'      => Controls_Manager::ICONS,
            'default'   => [
                'value'   => 'fas fa-check',
                'library' => 'fa-solid',
            ],
        ]
    );

	$repeater->end_controls_tab();

    $repeater->start_controls_tab(
		'style_tab',
		array(
			'label' => esc_html__( 'استایل', 'studiare-core' ),
			'tab'   => Controls_Manager::TAB_CONTENT,
		)
	);

    $repeater->add_control(
        'search_btn_color',
        [
            'label'     => esc_html__( 'زنگ آیکون', 'studiare-core' ),
            'type'      => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} span.list-icon ' => 'color: {{VALUE}}',
            ],
        ]
    );

    $repeater->end_controls_tab();

	$repeater->end_controls_tabs();

	$this->add_control(
		'items',
		array(
			'type'        => Controls_Manager::REPEATER,
			'title_field' => '{{{ list_title }}}',
			'fields'      => $repeater->get_controls(),
			'default'     => array(
				array(
					'item_title'   => 'عنوان لیست',
				),
				array(
					'item_title'   => 'عنوان لیست',
				),
				array(
					'item_title'   => 'عنوان لیست',
				),
			),
		)
	);

	$this->end_controls_section();



		/**
		 * Title settings
		 */
		$this->start_controls_section(
			'title_style_section',
			array(
				'label' => esc_html__( 'عنوان', 'studiare-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'title_typography',
				'label'    => esc_html__( 'تایپوگرافی', 'studiare-core' ),
				'selector' => '{{WRAPPER}} .list-title',
			)
		);

		$this->add_control(
			'title_text_idle_color',
			array(
				'label'     => esc_html__( 'رنگ', 'studiare-core' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .list-title' => 'color: {{VALUE}}',
				),
			)
		);

		$this->end_controls_section();
		

   }


   protected function render( $instance = [] ) {


    // get our input from the widget settings.
    $settings = $this->get_settings_for_display();
    
    ?>


        <ul class="lists-title">
            <?php foreach (  $settings['items'] as $list_single ): ?>
				<li class="elementor-repeater-list">
						<span class="list-icon">
                            <?php \Elementor\Icons_Manager::render_icon( $list_single['icon'], [ 'aria-hidden' => 'true' ] ); ?>
						</span>
					<span class="list-title">
                        <?php echo $list_single['list_title']; ?>
					</span>
				</li>
			<?php endforeach; ?>
        </ul>



      <?php
   }
}

Plugin::instance()->widgets_manager->register( new studiare_Widget_List_icon );
