<?php

namespace Engine\Modules\Layouts;

defined('ABSPATH') || exit;

use Elementor\Plugin;
use Engine\Engine;

abstract class Layout_Type extends Engine {
	/**
	 * Constructor.
	 */
	public function init() {
		add_filter( 'template_include', array( $this, 'override_template' ), 20 );
	}

	/**
	 * Check.
	 *
	 * @param array  $condition Condition.
	 * @param string $type      Layout type.
	 */
	public function check( $condition, $type = '' ) {
	}

	/**
	 * Override templates.
	 *
	 * @param string $template Template.
	 */
	public function override_template( $template ) {
	}

	/**
	 * Display template.
	 */
	private function display_template() {
	}

	/**
	 * Before template content.
	 */
	public function before_template_content() {
		get_header();
		do_action( 'woocommerce_before_main_content' );
	}

	/**
	 * After template content.
	 */
	public function after_template_content() {
		do_action( 'woocommerce_after_main_content' );
		get_footer();
	}

	/**
	 * Template content.
	 *
	 * @param string $type Template type.
	 */
	public function template_content( $type ) {
		$id   = apply_filters( 'wpml_object_id', Engine::get_instance()->get_layout_id( $type ), 'engine_layout' );
		$post = get_post( $id );

		if ( ! $post || 'engine_layout' !== $post->post_type || ! $id ) {
			return;
		}

		if ( Plugin::$instance->documents->get( $id )->is_built_with_elementor() ) {
			$content  = $this->std_elementor_get_content_css( $id );
			$content .= $this->std_elementor_get_content( $id );
		}

		echo $content; // phpcs:ignore
	}
}

