<?php

namespace Engine\Modules\Layouts;

defined('ABSPATH') || exit;

use Engine\Engine;
use WC_Product_Factory;
use WP_Query;

class Engine_Single_Product extends Layout_Type {
	/**
	 * Check.
	 *
	 * @param array  $condition Condition.
	 * @param string $type      Layout type.
	 */
	public function check( $condition, $type = '' ) {
		$is_active = false;

		switch ( $condition['condition_type'] ) {
			case 'all':
				$is_active = is_singular( 'product' );
				break;
			case 'product':
				$is_active = (int) get_the_ID() === (int) $condition['condition_query'];
				break;
			case 'product_type':
				$is_active = WC_Product_Factory::get_product_type( get_the_ID() ) === $condition['condition_query'];
				break;
			case 'product_cat':
			case 'product_tag':
			case 'product_attr_term':
				$terms = wp_get_post_terms( get_the_ID(), get_taxonomies(), array( 'fields' => 'ids' ) );

				if ( $terms ) {
					$is_active = in_array( (int) $condition['condition_query'], $terms, true );
				}
				break;
			case 'product_cat_children':
				$terms         = wp_get_post_terms( get_the_ID(), get_taxonomies(), array( 'fields' => 'ids' ) );
				$term_children = get_term_children( $condition['condition_query'], 'product_cat' );

				if ( $terms ) {
					$is_active = count( array_diff( $terms, $term_children ) ) !== count( $terms );
				}
				break;
		}

		return $is_active;
	}

	/**
	 * Override template.
	 *
	 * @param string $template Template.
	 *
	 * @return bool|string
	 */
	public function override_template( $template ) {
		if ( is_singular( 'product' ) && Engine::get_instance()->has_custom_layout( 'single_product' ) ) {
			$this->display_template();

			return false;
		}

		return $template;
	}

	/**
	 * Display custom template.
	 */
	private function display_template() {
		$this->before_template_content(); ?>
		<?php while ( have_posts() ) : ?>
			<?php the_post(); ?>
			<div id="product-<?php the_ID(); ?>" <?php wc_product_class( 'single-product-page' ); ?>>
				<?php $this->template_content( 'single_product' ); // phpcs:ignore ?>
				<?php if ( function_exists( 'WC' ) && is_object( WC()->structured_data ) ) : ?>
					<?php WC()->structured_data->generate_product_data(); ?>
				<?php endif; ?>
				<div class="wc-notices-el">
	    		<?php wc_print_notices(); ?>
	    		</div>
			</div>
		<?php endwhile; ?>
		<?php
		$this->after_template_content();
	}

	/**
	 * Get preview product id.
	 *
	 * @return int
	 */
	public static function get_preview_product_id() {
		$product_id = codebean_option( 'select_product_single' );

		if ( ! $product_id ) {
			$random_product = new WP_Query(
				array(
					'posts_per_page' => '1',
					'post_type'      => 'product',
				)
			);

			while ( $random_product->have_posts() ) {
				$random_product->the_post();
				$product_id = get_the_ID();
			}

			wp_reset_postdata();
		}

		return $product_id;
	}

	/**
	 * Setup post data.
	 */
	public static function setup_postdata( $force_product_id = false ) {
		global $post, $product;

		if ( ( Engine::is_layout_type( 'single_product') && empty( $product ) ) || is_singular( 'engine_layout' ) || wp_doing_ajax() || ( isset( $_POST['action'] ) && 'editpost' === $_POST['action'] ) || $force_product_id ) { // phpcs:ignore
			$product_id = $force_product_id ? $force_product_id : self::get_preview_product_id();
			$post = get_post( $product_id ); // phpcs:ignore

			setup_postdata( $post );
		}
	}

	/**
	 * Reset post data.
	 */
	public static function reset_postdata( $force_product_id = false ) {
		if ( is_singular( 'engine_layout' ) || wp_doing_ajax() || $force_product_id ) {
			wp_reset_postdata();
		}
	}
}

Engine_Single_Product::get_instance();
