<?php

namespace Engine\Modules\Layouts;
namespace Elementor;

use Elementor\Group_Control_Typography;
use Elementor\Plugin;
use Elementor\Widget_Base;
use Engine\Engine;

if (!defined('ABSPATH')) {
    exit; // Direct access not allowed.
}


class STD_Product_Add_Cart extends Widget_Base
{

    public function get_name()
    {
        return 'std_add_cart';
    }

    public function get_title()
    {
        return esc_html__('افزودن به سبدخرید', 'studiare');
    }

    public function get_icon()
    {
        return 'eicon-product-add-to-cart';
    }

    public function get_categories()
    {
        return array('std-single-product-elements');
    }

    public function show_in_panel()
    {
        return Engine::is_layout_type('single_product');
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'section_title',
            array(
                'label' => esc_html__('استایل افزودن به سبدخرید', 'studiare'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            )
        );


        $this->add_control(
			'style-add-cart',
			array(
				'label'   => esc_html__( 'انتخاب استایل', 'studiare-core' ),
				'type'    => Controls_Manager::SELECT,
				'options' => array(
					'std-add-t-cart'      => esc_html__( 'استایل اول', 'studiare-core' ),
					'std-add-t-cart-2' => esc_html__( 'استایل دوم', 'studiare-core' ),
				),
				'default' => 'std-add-t-cart',
			)
		);

        $this->start_controls_tabs(
            'style_box_holder_tabs'
        );

        $this->start_controls_tab(
            'style_box_normal_tab',
            [
                'label' => esc_html__('عادی', 'studiare'),
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'type_txt',
                'label' => __('تایپوگرافی متن دکمه', 'studiare'),
                'selector' => 'html {{WRAPPER}} .product-info-box .button',
            ]
        );

        $this->add_control(
            'color_txt',
            [
                'label' => __('رنگ متن دکمه', 'studiare'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    'html {{WRAPPER}} .product-info-box .button' => 'color: {{VALUE}}',
                ]
            ]
        );

        $this->add_control(
            'add_cart_bg',
            [
                'label' => __('رنگ پس زمینه دکمه خرید', 'studiare') ,
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => ['{{WRAPPER}} .product-info-box .button' => 'background-color: {{VALUE}}',
                ]
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'style_box_hover_tab',
            [
                'label' => esc_html__('هاور', 'studiare'),
            ]
        );

        $this->add_control(
            'color_txt_hover',
            [
                'label' => __('رنگ هاور متن دکمه', 'studiare'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    'html {{WRAPPER}} .product-info-box .button:hover' => 'color: {{VALUE}}',
                ]
            ]
        );

        $this->add_control(
            'add_cart_bg_hover',
            [
                'label' => __('رنگ پس زمینه دکمه خرید', 'studiare') ,
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => ['{{WRAPPER}} .product-info-box .button:hover' => 'background-color: {{VALUE}}',
                ]
            ]
        );

        

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display(); 

        Engine::setup_preview();
        global $product;
        $current_user = wp_get_current_user();
        $course_purchase = codebean_option('course_purchase');
        $course_student_text = codebean_option('course_student_text');
        ?>
        <?php if (wc_customer_bought_product($current_user->user_email, $current_user->ID, $product->get_id()) && ($course_purchase)) : ?>
            <div class="purchased-info-box">
            <i class="fas fa-graduation-cap"></i>
            <?php echo($course_student_text); ?>
            </div>
        <?php else : ?>
            <div class="<?php echo esc_attr( $settings['style-add-cart'] ); ?>">
            <?php woocommerce_template_single_add_to_cart(); ?>
            </div>
        <?php endif ?>

        <?php
        Engine::restore_preview();
    }
}

Plugin::instance()->widgets_manager->register(new STD_Product_Add_Cart());
