<?php

namespace Engine\Modules\Layouts;

use Elementor\Group_Control_Typography;
use Elementor\Plugin;
use Elementor\Widget_Base;
use Engine\Engine;

if (!defined('ABSPATH')) {
    exit; // Direct access not allowed.
}


class STD_Breadcrumb extends Widget_Base
{

    public function get_name()
    {
        return 'std_breadcrumb';
    }

    public function get_title()
    {
        return esc_html__('بردکرامب', 'studiare');
    }

    public function get_icon()
    {
        return 'eicon-product-breadcrumbs';
    }

    public function get_categories()
    {
        return array('std-single-product-elements');
    }

    public function show_in_panel()
    {
        return Engine::is_layout_type('single_product');
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'section_title',
            array(
                'label' => esc_html__('استایل بردکرامب', 'studiare'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            )
        );

        $this->add_responsive_control(
            'title_alignment',
            [
                'label' => esc_html__('موقعیت', 'studiare'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'right' => [
                        'title' => esc_html__('Right', 'studiare'),
                        'icon' => 'eicon-text-align-right',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'studiare'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'left' => [
                        'title' => esc_html__('Left', 'studiare'),
                        'icon' => 'eicon-text-align-left',
                    ],
                ],
                'selectors' => [
                    'html {{WRAPPER}} .woocommerce-breadcrumb' => 'text-align: {{VALUE}};'
                ],
                'default' => 'right',
            ]
        );

        $this->start_controls_tabs(
            'style_box_holder_tabs'
        );

        $this->start_controls_tab(
            'style_box_norma0l_tab',
            [
                'label' => esc_html__('عادی', 'studiare'),
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'type_title',
                'label' => __('تایپوگرافی متن ها', 'studiare'),
                'selector' => 'html {{WRAPPER}} .woocommerce-breadcrumb',
                'default' => '#333'
            ]
        );

        $this->add_control(
            'color_url',
            [
                'label' => __('رنگ لینک (URL)', 'studiare'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    'html {{WRAPPER}} .woocommerce-breadcrumb a' => 'color: {{VALUE}}',
                ],
                'default' => '#333'
            ]
        );

        $this->add_control(
            'color_icon',
            [
                'label' => __('رنگ آیکون', 'studiare'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    'html {{WRAPPER}} .woocommerce-breadcrumb i' => 'color: {{VALUE}}',
                ],
                'default' => '#333'
            ]
        );

        $this->add_control(
            'color_txt',
            [
                'label' => __('رنگ متن', 'studiare'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    'html {{WRAPPER}} .woocommerce-breadcrumb' => 'color: {{VALUE}}',
                ],
                'default' => '#333'
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'style_box_hover_tab',
            [
                'label' => esc_html__('هاور', 'studiare'),
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'type_title_hover',
                'label' => __('تایپوگرافی هاور متن ها', 'studiare'),
                'selector' => 'html {{WRAPPER}} .woocommerce-breadcrumb:hover',
            ]
        );

        $this->add_control(
            'color_url_hover',
            [
                'label' => __('رنگ هاور لینک (URL)', 'studiare'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    'html {{WRAPPER}} .woocommerce-breadcrumb a:hover' => 'color: {{VALUE}}',
                ]
            ]
        );

        $this->add_control(
            'color_icon_hover',
            [
                'label' => __('رنگ هاور آیکون', 'studiare'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    'html {{WRAPPER}} .woocommerce-breadcrumb:hover i' => 'color: {{VALUE}}',
                ]
            ]
        );

        $this->add_control(
            'color_txt_hover',
            [
                'label' => __('رنگ هاور متن', 'studiare'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    'html {{WRAPPER}} .woocommerce-breadcrumb:hover' => 'color: {{VALUE}}',
                ]
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();
    }

    protected function render()
    {
        Engine::setup_preview();
        woocommerce_breadcrumb();
        Engine::restore_preview();
    }
}

Plugin::instance()->widgets_manager->register(new STD_Breadcrumb());
