<?php

namespace Engine\Modules\Layouts;

use Elementor\Group_Control_Typography;
use Elementor\Plugin;
use Elementor\Widget_Base;
use Engine\Engine;

if (!defined('ABSPATH')) {
    exit; // Direct access not allowed.
}


class STD_Location_Map extends Widget_Base
{

    public function get_name()
    {
        return 'std_location_map';
    }

    public function get_title()
    {
        return esc_html__('محل برگزاری', 'studiare');
    }

    public function get_icon()
    {
        return 'eicon-google-maps';
    }

    public function get_categories()
    {
        return array('std-single-product-elements');
    }

    public function show_in_panel()
    {
        return Engine::is_layout_type('single_product');
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'section_title',
            array(
                'label' => esc_html__('استایل محل برگزاری', 'studiare'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            )
        );

        $this->start_controls_tabs(
            'style_box_holder_tabs'
        );

        $this->start_controls_tab(
            'style_box_normal_tab',
            [
                'label' => esc_html__('عادی', 'studiare'),
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'type_title',
                'label' => __('تایپوگرافی عنوان', 'studiare'),
                'selector' => 'html {{WRAPPER}} .product-reviews .product-review-title .inner',
            ]
        );

        $this->add_control(
            'color_txt_title',
            [
                'label' => __('رنگ عنوان', 'studiare'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    'html {{WRAPPER}} .product-reviews .product-review-title .inner' => 'color: {{VALUE}}',
                ]
            ]
        );

        $this->add_control(
            'color_bottom_title_box',
            [
                'label' => __('رنگ خط پایین عنوان', 'studiare'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    'html {{WRAPPER}} .product-reviews .product-review-title .inner:after' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'bg_box',
                'label' => esc_html__('پس زمینه', 'studiare'),
                'types' => ['classic', 'gradient'],
                'selector' => 'html {{WRAPPER}} .stdProductLocation',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'border_box',
                'label' => esc_html__('کادر دور', 'studiare'),
                'selector' => 'html {{WRAPPER}} .stdProductLocation',
            ]
        );

        $this->add_responsive_control(
            'border_radius_box',
            [
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'label' => esc_html__('گردی دور', 'studiare'),
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    'html {{WRAPPER}} .stdProductLocation' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'box_padding',
            [
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'label' => esc_html__('فاصله داخلی', 'studiare'),
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    'html {{WRAPPER}} .stdProductLocation' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadow',
                'label' => __('سایه', 'studiare'),
                'selector' => 'html {{WRAPPER}} .stdProductLocation',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'style_box_hover_tab',
            [
                'label' => esc_html__('هاور', 'studiare'),
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'type_title_hover',
                'label' => __('تایپوگرافی هاور عنوان', 'studiare'),
                'selector' => 'html {{WRAPPER}} .product-reviews .product-review-title .inner:hover',
            ]
        );

        $this->add_control(
            'color_txt_title_hover',
            [
                'label' => __('رنگ هاور عنوان', 'studiare'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    'html {{WRAPPER}} .product-reviews .product-review-title .inner:hover' => 'color: {{VALUE}}',
                ]
            ]
        );

        $this->add_control(
            'color_bottom_title_box_hover',
            [
                'label' => __('رنگ هاور خط پایین عنوان', 'studiare'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    'html {{WRAPPER}} .product-reviews .product-review-title .inner:hover:after' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'bg_box_hover',
                'label' => esc_html__('هاور پس زمینه', 'studiare'),
                'types' => ['classic', 'gradient'],
                'selector' => 'html {{WRAPPER}} .stdProductLocation:hover',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'border_box_hover',
                'label' => esc_html__('هاور کادر دور', 'studiare'),
                'selector' => 'html {{WRAPPER}} .stdProductLocation:hover',
            ]
        );

        $this->add_responsive_control(
            'border_radius_box_hover',
            [
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'label' => esc_html__('هاور گردی دور', 'studiare'),
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    'html {{WRAPPER}} .stdProductLocation:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'box_padding_hover',
            [
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'label' => esc_html__('هاور فاصله داخلی', 'studiare'),
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    'html {{WRAPPER}} .stdProductLocation:hover' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadow_hover',
                'label' => __('هاور سایه', 'studiare'),
                'selector' => 'html {{WRAPPER}} .stdProductLocation:hover',
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();
    }

    protected function render()
    {
        $prefix = '_studiare_';
        Engine::setup_preview();
        $location_google_map = get_post_meta(get_the_ID(), $prefix . 'location_google_map', true);
        if ($location_google_map) : ?>
            <div class="product-reviews stdProductLocation">
                <div class="product-review-title">
                    <h3 class="inner"><i class="material-icons">location_on</i>محل برگزاری</h3>
                </div>
                <div class="product-reviews-inner">
                    <?php echo($location_google_map); ?>
                </div>
            </div>
        <?php endif;
        Engine::restore_preview();
    }
}

Plugin::instance()->widgets_manager->register(new STD_Location_Map());
