<?php

namespace Engine\Modules\Layouts;

use Elementor\Group_Control_Typography;
use Elementor\Plugin;
use Elementor\Widget_Base;
use Engine\Engine;

if (!defined('ABSPATH')) {
    exit; // Direct access not allowed.
}

class STD_Product_Category extends Widget_Base
{

    public function get_name()
    {
        return 'std_product_category';
    }

    public function get_title()
    {
        return esc_html__('دسته بندی محصول', 'studiare');
    }

    public function get_icon()
    {
        return 'eicon-product-categories';
    }

    public function get_categories()
    {
        return array('std-single-product-elements');
    }

    public function show_in_panel()
    {
        return Engine::is_layout_type('single_product');
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'section_title',
            array(
                'label' => esc_html__('دسته بندی محصول', 'studiare'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            )
        );

        $this->add_control(
            'reviews_note',
            array(
                'type' => \Elementor\Controls_Manager::RAW_HTML,
                'raw' => esc_html__('این المان تنظیماتی ندارد :)', 'studiare'),
                'content_classes' => 'elementor-panel-alert elementor-panel-alert-info',
            )
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        Engine::setup_preview();
        global $product;
        echo '<div class="product-info-box stdProductHolder">';
        echo wc_get_product_category_list($product->get_id(), '، ', '<span class="posted_in"><i class="fal fa-list"></i>' . _n('Category:', 'Categories:', count($product->get_category_ids()), 'woocommerce') . ' ', '</span>');
        echo '</div>';
        Engine::restore_preview();
    }
}

Plugin::instance()->widgets_manager->register(new STD_Product_Category());
