<?php

namespace Engine\Modules\Layouts;

use Elementor\Group_Control_Typography;
use Elementor\Plugin;
use Elementor\Widget_Base;
use Engine\Engine;

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Direct access not allowed.
}


class STD_Product_Comments extends Widget_Base {

    public function get_name() {
        return 'std_comments_product';
    }

    public function get_title() {
        return esc_html__( 'نظرات محصول', 'studiare' );
    }

    public function get_icon() {
        return 'eicon-comments';
    }

    public function get_categories() {
        return array( 'std-single-product-elements' );
    }

    public function show_in_panel() {
        return Engine::is_layout_type( 'single_product' );
    }

    protected function register_controls() {

       
    }

    protected function render() {
        $default_settings = array(
            'product_id' => false,
        );

        $settings = wp_parse_args( $this->get_settings_for_display(), $default_settings );

        $course_detail_reviews = codebean_option('course_detail_reviews');

        $rating_enabled = get_option('woocommerce_enable_review_rating');

        Engine::setup_preview( array(), $settings['product_id'] );
		 if ( $course_detail_reviews ) : ?>
            <div class="product-reviews">

                <div class="product-review-title">
                    <h3 class="inner"><i class="fal fa-percent"></i><?php esc_html_e( 'امتیاز دانشجویان دوره', 'studiare' ); ?></h3>
                </div>

                <div class="product-reviews-inner">
                <?php if($rating_enabled == 'yes'):
                        $product = wc_get_product(get_the_id());
                        $rating_count = $product->get_rating_count();
                        $average      = $product->get_average_rating();
                        $average = round($average, 1); ?>
                        <div class="product-reviews-stats">
                            <!-- Averate Rating -->
                            <div class="average-rating">
                                <div class="avareage-rating-inner">
                                    <div class="average-rating-number"><?php echo esc_attr($average); ?></div>
                                    <div class="average-rating-stars">
                                        <?php do_action( 'woocommerce_after_shop_loop_item_title' ); ?>
                                    </div>
                                    <div class="average-rating-label">
                                        <?php echo esc_attr($rating_count.' '.esc_html__('رأی', 'studiare')); ?>
                                    </div>
                                </div>
                            </div>

                            <!-- Detailed Ratings-->
                            <?php
                            // WP_Comment_Query arguments
                            $args = array (
                                'status'         => 'approve',
                                'type'           => 'review',
                                'post_id'        => get_the_id(),
                            );

                            // The Comment Query
                            $woo_reviews = new \WP_Comment_Query;
                            $comments = $woo_reviews->query( $args );

                            $rate1 = $rate2 = $rate3 = $rate4 = $rate5 = 0;
                            // The Comment Loop
                            if ( $comments ) {
                                foreach ( $comments as $comment ) {
                                    $rate = get_comment_meta($comment->comment_ID, 'rating', true);
                                    switch($rate) {
                                        case 1:
                                            $rate1++;
                                            break;
                                        case 2:
                                            $rate2++;
                                            break;
                                        case 3:
                                            $rate3++;
                                            break;
                                        case 4:
                                            $rate4++;
                                            break;
                                        case 5:
                                            $rate5++;
                                            break;
                                    } // switch
                                }
                            }
                            $rates = array('5'=>$rate5,'4'=>$rate4,'3'=>$rate3,'2'=>$rate2,'1'=>$rate1);
                            ?>
                            <div class="detailed-ratings">
                                <div class="detailed-ratings-inner">
	                                <?php foreach($rates as $key => $rate): ?>
		                                <?php
		                                if($rate !=0 or $rating_count != 0) {
			                                $fill_value = round($rate*100/$rating_count, 2);
		                                } else {
			                                $fill_value = 0;
		                                }
		                                ?>
                                        <div class="course-rating">
                                            <span class="number"><?php echo esc_attr($key.' '.__('Stars', 'studiare')); ?></span>
                                            <div class="bar">
                                                <div class="bar-fill" style="width:<?php echo esc_attr($fill_value); ?>%"></div>
                                            </div>
                                            <span class="counter"><?php echo esc_attr($rate); ?></span>
                                        </div>
	                                <?php endforeach; ?>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
			<?php endif; ?>

			<?php if ( comments_open() ): ?>
			<div class="product-reviews">
				<div class="product-review-title">
                    <h3 class="inner"><i class="fal fa-comment-alt-dots"></i><?php esc_html_e( 'Reviews', 'studiare' ); ?></h3>
                </div>
				<div class="product-reviews-inner">

                        <?php comments_template(); ?>

				</div>
			</div>
			<?php else: ?>
			<?php endif;
        Engine::restore_preview( $settings['product_id'] );
    }
}

Plugin::instance()->widgets_manager->register( new STD_Product_Comments() );
