<?php

namespace Engine\Modules\Layouts;

use Elementor\Group_Control_Typography;
use Elementor\Plugin;
use Elementor\Widget_Base;
use Engine\Engine;

if (!defined('ABSPATH')) {
    exit; // Direct access not allowed.
}

class STD_Product_Content extends Widget_Base
{

    public function get_name()
    {
        return 'std_content_product';
    }

    public function get_title()
    {
        return esc_html__('محتوای محصول', 'studiare');
    }

    public function get_icon()
    {
        return 'eicon-text';
    }

    public function get_categories()
    {
        return array('std-single-product-elements');
    }

    public function show_in_panel()
    {
        return Engine::is_layout_type('single_product');
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'section_title',
            array(
                'label' => esc_html__('استایل محتوای محصول', 'studiare'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            )
        );

        $this->start_controls_tabs(
            'style_box_holder_tabs'
        );

        $this->start_controls_tab(
            'style_box_normal_tab',
            [
                'label' => esc_html__('عادی', 'studiare'),
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'bg_box',
                'label' => esc_html__('پس زمینه', 'studiare'),
                'types' => ['classic', 'gradient'],
                'selector' => 'html {{WRAPPER}} .stdProductContent',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'border_box',
                'label' => esc_html__('کادر دور', 'studiare'),
                'selector' => 'html {{WRAPPER}} .stdProductContent',
            ]
        );

        $this->add_responsive_control(
            'border_radius_box',
            [
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'label' => esc_html__('گردی دور', 'studiare'),
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    'html {{WRAPPER}} .stdProductContent' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'box_padding',
            [
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'label' => esc_html__('فاصله داخلی', 'studiare'),
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    'html {{WRAPPER}} .stdProductContent' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadow',
                'label' => __('سایه', 'studiare'),
                'selector' => 'html {{WRAPPER}} .stdProductContent',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'style_box_hover_tab',
            [
                'label' => esc_html__('هاور', 'studiare'),
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'bg_box_hover',
                'label' => esc_html__('هاور پس زمینه', 'studiare'),
                'types' => ['classic', 'gradient'],
                'selector' => 'html {{WRAPPER}} .stdProductContent:hover',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'border_box_hover',
                'label' => esc_html__('هاور کادر دور', 'studiare'),
                'selector' => 'html {{WRAPPER}} .stdProductContent:hover',
            ]
        );

        $this->add_responsive_control(
            'border_radius_box_hover',
            [
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'label' => esc_html__('هاور گردی دور', 'studiare'),
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    'html {{WRAPPER}} .stdProductContent:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'box_padding_hover',
            [
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'label' => esc_html__('هاور فاصله داخلی', 'studiare'),
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    'html {{WRAPPER}} .stdProductContent:hover' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadow_hover',
                'label' => __('هاور سایه', 'studiare'),
                'selector' => 'html {{WRAPPER}} .stdProductContent:hover',
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();
    }

    protected function render()
    {
        Engine::setup_preview();

        $editor = Plugin::$instance->editor;
        $is_edit_mode = $editor->is_edit_mode();
        $editor->set_edit_mode(false);
        $post_id = get_the_ID();
        $document = Plugin::$instance->documents->get_doc_for_frontend($post_id);
        $content = Plugin::$instance->frontend->get_builder_content($post_id, $is_edit_mode);

        echo '<div class="product-single-content stdProductContent">';

        if ($document->is_built_with_elementor() && $content) {
            echo do_shortcode($content); // phpcs:ignore
        } else {
            the_content();
        }

        echo '</div>';
        Plugin::$instance->editor->set_edit_mode($is_edit_mode);

        Engine::restore_preview();
    }
}

Plugin::instance()->widgets_manager->register(new STD_Product_Content());
