<?php

namespace Engine\Modules\Layouts;

use Elementor\Group_Control_Typography;
use Elementor\Plugin;
use Elementor\Widget_Base;
use Engine\Engine;

if (!defined('ABSPATH')) {
    exit; // Direct access not allowed.
}


class STD_Product_Count extends Widget_Base
{

    public function get_name()
    {
        return 'std_sell_Count';
    }

    public function get_title()
    {
        return esc_html__('تعداد فروش', 'studiare');
    }

    public function get_icon()
    {
        return 'eicon-counter';
    }

    public function get_categories()
    {
        return array('std-single-product-elements');
    }

    public function show_in_panel()
    {
        return Engine::is_layout_type('single_product');
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'section_title',
            array(
                'label' => esc_html__('تعداد فروش', 'studiare'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            )
        );
        $this->add_control(
            'reviews_note',
            array(
                'type' => \Elementor\Controls_Manager::RAW_HTML,
                'raw' => esc_html__('این المان تنظیماتی ندارد :)', 'studiare'),
                'content_classes' => 'elementor-panel-alert elementor-panel-alert-info',
            )
        );
        $this->end_controls_section();
    }

    protected function render()
    {
        $course_students = codebean_option('course_students');

        Engine::setup_preview();
        global $post;
        if ($course_students) : ?>
            <div class="product-info-box stdProductHolder stdProductSell">
                <div class="total_sales">
                    <i class="fal fa-user-graduate"></i> تعداد دانشجو :
                    <span><?php $count = get_post_meta($post->ID, 'total_sales', true);
                        $text = sprintf(_n('%s', '%s', $count, 'wpdocs_textdomain'), number_format_i18n($count));
                        echo $text; ?></span>
                </div>
            </div>
        <?php endif;
        Engine::restore_preview();
    }
}

Plugin::instance()->widgets_manager->register(new STD_Product_Count());
