<?php

namespace Engine\Modules\Layouts;

use Elementor\Group_Control_Typography;
use Elementor\Plugin;
use Elementor\Widget_Base;
use Engine\Engine;

if (!defined('ABSPATH')) {
    exit; // Direct access not allowed.
}

class STD_Product_Countdown extends Widget_Base
{

    public function get_name()
    {
        return 'std_product_countdown';
    }

    public function get_title()
    {
        return esc_html__('تایمر معکوس شگفت انگیز', 'studiare');
    }

    public function get_icon()
    {
        return 'eicon-countdown';
    }

    public function get_categories()
    {
        return array('std-single-product-elements');
    }

    public function show_in_panel()
    {
        return Engine::is_layout_type('single_product');
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'section_title',
            array(
                'label' => esc_html__('تایمر معکوس شگفت انگیز', 'studiare'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            )
        );
        $this->add_control(
        'color_txt_title', [
            'label' => __('رنگ اصلی شمارشگر معکوس', 'studiare') ,
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => ['{{WRAPPER}} .deal_timer_single .countdown-col span.countdown-sec span.number' => 'background-color: {{VALUE}}',
            '{{WRAPPER}} .deal_timer_single .deal-text span ' => 'color: {{VALUE}}',

        ]]);

        $this->end_controls_section();
    }

    protected function render()
    {
        Engine::setup_preview();
        global $product;
        $course_purchase = codebean_option('course_purchase');
        $current_user = wp_get_current_user();
        if (wc_customer_bought_product($current_user->user_email, $current_user->ID, $product->get_id()) && ($course_purchase)) {
            echo '';
        } else {
            do_action('woocommerce_single_product_countdown');
        }
        Engine::restore_preview();
    }
}

Plugin::instance()->widgets_manager->register(new STD_Product_Countdown());
