<?php
namespace Engine\Modules\Layouts;
namespace Elementor;

use Elementor\Group_Control_Typography;
use Elementor\Plugin;
use Elementor\Widget_Base;
use Engine\Engine;

if (!defined('ABSPATH'))
{
    exit; // Direct access not allowed.
    
}

class STD_Lander extends Widget_Base
{

    public function get_name()
    {
        return 'std_single_product_lander';
    }

    public function get_title()
    {
        return esc_html__('لندر', 'studiare');
    }

    public function get_icon()
    {
        return 'eicon-t-letter';
    }

    public function get_categories()
    {
        return array(
            'std-single-product-elements'
        );
    }

    public function show_in_panel()
    {
        return Engine::is_layout_type('single_product');
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'nav_section',
            array(
                'label' => esc_html__('منوی ناوبری', 'studiare'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            )
        );

        $repeater = new \Elementor\Repeater();

         $repeater->add_control(
            'nav_item',
            [
               'label' => __( 'متن آیتم منو', 'studiare-core' ),
               'type' => \Elementor\Controls_Manager::TEXT,
               'default' => 'صفحه اصلی'
            ]
         );

         $repeater->add_control(
            'nav_item_url',
            [
               'label' => __( 'نشانی', 'studiare-core' ),
               'type' => \Elementor\Controls_Manager::TEXT,
            ]
         );


         $this->add_control(
            'nav_list',
            array(
                'type'        => Controls_Manager::REPEATER,
                'title_field' => '{{{ nav_item }}}',
                'fields'      => $repeater->get_controls(),
                'default'     => array(
                    array(
                        'nav_item'   => 'صفحه اصلی',
                        'nav_item_url' => '#',
                    ),
                    array(
                        'nav_item'   => 'توضیحات',
                        'nav_item_url' => '#tozih',
                    ),
                    array(
                        'nav_item'   => 'سرفصل ها',
                        'nav_item_url' => '#fasl',
                    ),
                ),
            )
        );

        
        $this->end_controls_section();
        
        $this->start_controls_section('section_style', array(
            'label' => esc_html__('استایل عنوان محصول', 'studiare') ,
            'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ));

        $this->add_control('color_txt_title', [
            'label' => __('رنگ پس زمینه لندر', 'studiare') ,
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => ['html {{WRAPPER}} .land-header, .land-header .left-col' => 'background-color: {{VALUE}}',
            '{{WRAPPER}} .land-header .right .title h1.entry-title , .land-header .navbar .navbar-nav .nav-link.cmp-btn-def ' => 'color: {{VALUE}}',

        ]]);

        $this->end_controls_section();
    }

    protected function render()
    {
        $prefix = '_studiare_';

        $teacher_id = get_post_meta(get_the_ID() , $prefix . 'course_teacher', true);
        $teacher_post = get_post($teacher_id);
        $teacher_job_title = get_post_meta($teacher_id, $prefix . 'teacher_job_title', true);

        $default_settings = array(
            'product_id' => false,
        );

        $settings = wp_parse_args($this->get_settings_for_display() , $default_settings);
        

        Engine::setup_preview(array() , $settings['product_id']);

        $course_disable_image = get_post_meta(get_the_ID() , $prefix . 'course_disable_image', true);
        $course_video = get_post_meta(get_the_ID() , $prefix . 'course_video', true);
        $poster_video_coures = get_post_meta(get_the_ID() , $prefix . 'poster_video_coures', true);

        echo '<div class="course-single-gallery stdCourseVideo">';

        if ($course_disable_image):
            $attr = array(
                'mp4' => $course_video,
                'poster' => $poster_video_coures,
                'preload' => 'none',
                'width' => '1200',
                'height' => '700'
            );
            echo wp_video_shortcode($attr);

        else:
            $this->std_gallery_img();
        endif;

        echo '</div>';

        Engine::restore_preview($settings['product_id']);
    }

    public function std_gallery_img()
    {
        if (!function_exists('wc_get_gallery_image_html'))
        {
            return;
        }

        $nav_settings = $this->get_settings_for_display(); 

        global $post, $product;

        $prefix = '_studiare_';

        $current_user = wp_get_current_user();
        $course_purchase = codebean_option('course_purchase');
        $course_student_text = codebean_option('course_student_text');

        $teacher_id = get_post_meta(get_the_ID() , $prefix . 'course_teacher', true);
        $teacher_post = get_post($teacher_id);
        $teacher_job_title = get_post_meta($teacher_id, $prefix . 'teacher_job_title', true);

        $duration = get_post_meta(get_the_ID() , $prefix . 'course_duration', true);
        $lessons = get_post_meta(get_the_ID() , $prefix . 'course_lesseons', true);
        $course_support = get_post_meta(get_the_ID() , $prefix . 'course_support', true);
        $course_shoar = get_post_meta(get_the_ID() , $prefix . 'course_shoar', true);

        $course_video = get_post_meta(get_the_ID() , $prefix . 'course_video', true);

        $post_thumbnail_id = get_post_thumbnail_id($post->ID);
        $full_size_image = wp_get_attachment_image_src($post_thumbnail_id, 'full');
        $image_title = get_post_field('post_excerpt', $post_thumbnail_id);
        $wrapper_classes = apply_filters('woocommerce_single_product_image_gallery_classes', array(
            'woocommerce-product-gallery',
        ));
?>

        <div class="land-header">

        <nav class="navbar navbar-dark navbar-expand-lg" id="top">
            <div class="container">
            <button class="navbar-toggler hide-toggle" type="button" data-bs-toggle="collapse" data-bs-target="#navbarText" aria-controls="navbarText" aria-expanded="true" aria-label="Toggle navigation">
            <i class="fal fa-bars"></i>
            </button>
        <div class="navbar-collapse collapse" id="navbarText">
            <ul class="navbar-nav navbar-nav-right">
                <?php foreach (  $nav_settings['nav_list'] as $nav_single ): ?>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo $nav_single['nav_item_url']; ?>"><?php echo $nav_single['nav_item']; ?></a>
                </li>
                <?php endforeach; ?>
            </ul>
        </div>
        <ul class="navbar-nav navbar-nav-left me-auto">
      
            <li class="nav-item">
                <?php if (wc_customer_bought_product($current_user->user_email, $current_user->ID, $product->get_id()) && ($course_purchase)) : ?>
                    <a class="nav-link cmp-btn-def" href="#"><i class="far fa-graduation-cap"></i><?php echo($course_student_text); ?></a>
                    <?php else : ?>
                    <a class="nav-link cmp-btn-def" href="#buy"><i class="far fa-money-check-pen"></i>ثبت نام در دوره</a>
                <?php endif ?>
            </li>

                       
        </ul>
        </div>
        </nav>
         
            <div class="container">
                <div class="row">
                    <div class="col-lg-6">
                        <div class="right pb-5">
                            <span class="title"><?php wc_get_template('single-product/title.php'); ?></span>
                                <span class="subtitle" id="meta_slogan"><?php the_excerpt(); ?></span>
     
                            <div class="<?php echo esc_attr(implode(' ', array_map('sanitize_html_class', $wrapper_classes))); ?>"
             style="transition: opacity .25s ease-in-out;">
            <div class="product-image-wrapper">
                <?php
        $attributes = array(
            'title' => $image_title,
            'data-src' => $full_size_image[0]
        );

        if (has_post_thumbnail())
        {
            $html = get_the_post_thumbnail($post->ID, 'full', $attributes);
        }
        else
        {
            $html = sprintf('<img src="%s" alt="%s" data-src="%s" data-large_image="%s" data-large_image_width="800" data-large_image_height="600" class="attachment-shop_single size-shop_single wp-post-image" />', esc_url(wc_placeholder_img_src()) , esc_html__('Awaiting product image', 'studiare') , esc_url(wc_placeholder_img_src()) , esc_url(wc_placeholder_img_src()));
        }

        echo apply_filters('woocommerce_single_product_image_thumbnail_html', $html, $post_thumbnail_id); ?>

                <?php if ($course_video): ?>
                    <div class="video-button">
                        <a data-post-id="<?php echo get_the_ID(); ?>" href="<?php echo esc_url($course_video); ?>"
                           class="cdb-video-icon video-thumbnail"><i class="fal fa-play"></i></a>
                    </div>
                <?php
        endif; ?>

            </div>
        </div>
    
                            
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="left">
                            <div class="circle">
                            <?php $teacher_image = wp_get_attachment_image_src(get_post_thumbnail_id($teacher_id) , '', false); ?>
                                <img class="teacher" src="<?php echo esc_url($teacher_image[0]); ?>" alt="<?php echo esc_attr(get_the_title($teacher_id)); ?>">
                               
                            </div>
                            <div class="tabs">

                                <?php if (!empty($duration)): ?>
                                    <div>
                                        <i class="fal fa-clock"></i><?php echo esc_html($duration); ?>
                                    </div>
                                <?php
        endif; ?>
                                
                                <?php if (!empty($lessons)): ?>
                                    <div>
                                        <i class="fal fa-list-alt"></i><?php echo esc_html($lessons); ?>
                                    </div>
                                <?php
        endif; ?>

                                <?php if (!empty($course_support)): ?>
                                    <div>
                                        <i class="fal fa-headset"></i><?php echo esc_html($course_support); ?>
                                    </div>
                                <?php
        endif; ?>

                                                         
                            </div>
                            <span class="footer-text">
                                 
                            <?php if (!empty($course_shoar)): ?>
                                 <i class="fas fa-shield-check"></i><?php echo esc_html($course_shoar); ?>
                            <?php endif; ?>
                                       
                            </span>
                        </div>
                    </div>
                </div>
            </div>
            <div class="left-col">
            </div> 
        </div>
        <?php
    }

}

Plugin::instance()
    ->widgets_manager
    ->register(new STD_Lander());

