<?php

namespace Engine\Modules\Layouts;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Plugin;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Engine\Engine;

if (!defined('ABSPATH')) {
    exit; // Direct access not allowed.
}


class STD_Product_MetaList extends Widget_Base
{

    public function get_name()
    {
        return 'std_product_meta_List';
    }

    public function get_title()
    {
        return esc_html__('متاکلید های محصول', 'studiare');
    }

    public function get_icon()
    {
        return 'eicon-product-meta';
    }

    public function get_categories()
    {
        return array('std-single-product-elements');
    }

    public function show_in_panel()
    {
        return Engine::is_layout_type('single_product');
    }

    public function list_meta($meta)
    {
        $list = [
            'zero' => [
                'icon' => '',
                'title' => ''
            ],
            'course_type' => [
                'icon' => 'fal fa-map-marker-alt',
                'title' => 'نوع دوره :'
            ],
            'course_level' => [
                'icon' => 'fal fa-book-reader',
                'title' => 'سطح دوره :'
            ],
            'course_prerequisite' => [
                'icon' => 'fal fa-traffic-light-slow',
                'title' => 'پیش نیاز :'
            ],
            'course_start_date' => [
                'icon' => 'fal fa-calendar-day',
                'title' => 'تاریخ شروع :'
            ],
            'course_update_date' => [
                'icon' => 'fal fa-calendar-edit',
                'title' => 'تاریخ بروزرسانی :'
            ],
            'course_language' => [
                'icon' => 'fal fa-globe',
                'title' => 'زبان :'
            ],
            'course_duration' => [
                'icon' => 'fal fa-clock',
                'title' => ''
            ],
            'course_lesseons' => [
                'icon' => 'fal fa-list-alt',
                'title' => ''
            ],
            'course_file_size' => [
                'icon' => 'fal fa-hdd',
                'title' => ''
            ],
            'course_receive_type' => [
                'icon' => 'fal fa-long-arrow-alt-down',
                'title' => 'روش دریافت :'
            ],
            'course_support' => [
                'icon' => 'fal fa-user-headset',
                'title' => 'روش پشتیبانی :'
            ],
            'course_certificate' => [
                'icon' => 'fal fa-file-certificate',
                'title' => ''
            ],
            'course_percent' => [
                'icon' => 'fal fa-tasks',
                'title' => 'درصد پیشرفت دوره :'
            ],
        ];

        return $list[$meta];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'section_title',
            array(
                'label' => esc_html__('متاکلید های محصول', 'studiare'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            )
        );

        $this_meta = new Repeater();

        $this_meta->add_control(
            'select_meta',
            [
                'label' => __('انتخاب متاکلید', 'studiare'),
                'type' => Controls_Manager::SELECT,
                'default' => 'zero',
                'options' => [
                    'zero' => __('انتخاب کنید...', 'studiare'),
                    'course_type' => __('نوع دوره', 'studiare'),
                    'course_level' => __('سطح دوره', 'studiare'),
                    'course_prerequisite' => __('پیش نیاز', 'studiare'),
                    'course_start_date' => __('تاریخ شروع', 'studiare'),
                    'course_update_date' => __('تاریخ بروزرسانی', 'studiare'),
                    'course_language' => __('زبان', 'studiare'),
                    'course_duration' => __('مدت زمان', 'studiare'),
                    'course_lesseons' => __('تعداد سرفصل ها', 'studiare'),
                    'course_file_size' => __('حجم کل دوره', 'studiare'),
                    'course_receive_type' => __('روش دریافت', 'studiare'),
                    'course_support' => __('روش پشتیبانی', 'studiare'),
                    'course_certificate' => __('گواهی نامه', 'studiare'),
                    'feture_group' => __('ویژگی های سفارشی', 'studiare'),
                    'course_percent' => __('درصد پیشرفت دوره', 'studiare'),
                ],
                'label_block' => true,
            ]
        );

        $this_meta->add_control(
            'title',
            [
                'label' => __('عنوان (دلخواه)', 'studiare'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );

        $this->add_control(
            'all_meta',
            [
                'label' => __('متا آیتم ها', 'studiare'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $this_meta->get_controls(),
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'style_meta',
            array(
                'label' => esc_html__('استایل متاکلید های محصول', 'studiare'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            )
        );

        $this->add_responsive_control(
            'title_alignment',
            [
                'label' => esc_html__('موقعیت', 'studiare'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'right' => [
                        'title' => esc_html__('Right', 'studiare'),
                        'icon' => 'eicon-text-align-right',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'studiare'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'left' => [
                        'title' => esc_html__('Left', 'studiare'),
                        'icon' => 'eicon-text-align-left',
                    ],
                ],
                'selectors' => [
                    'html {{WRAPPER}} .product-meta-info-list .meta-info-unit' => 'justify-content: {{VALUE}};'
                ],
                'default' => 'right',
            ]
        );

        $this->start_controls_tabs(
            'style_box_holder_tabs'
        );

        $this->start_controls_tab(
            'style_box_normal_tab',
            [
                'label' => esc_html__('عادی', 'studiare'),
            ]
        );

        $this->add_control(
            'color_icon',
            [
                'label' => __('رنگ آیکون', 'studiare'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    'html {{WRAPPER}} .product-meta-info-list .meta-info-unit .icon' => 'color: {{VALUE}}',
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'type_title',
                'label' => __('تایپوگرافی عنوان', 'studiare'),
                'selector' => 'html {{WRAPPER}} .product-meta-info-list .meta-info-unit .value',
            ]
        );

        $this->add_control(
            'color_title',
            [
                'label' => __('رنگ عنوان', 'studiare'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    'html {{WRAPPER}} .product-meta-info-list .meta-info-unit .value' => 'color: {{VALUE}}',
                ]
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'style_box_hover_tab',
            [
                'label' => esc_html__('هاور', 'studiare'),
            ]
        );

        $this->add_control(
            'color_icon_hover',
            [
                'label' => __('رنگ هاور آیکون', 'studiare'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    'html {{WRAPPER}} .product-meta-info-list .meta-info-unit:hover .icon' => 'color: {{VALUE}}',
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'type_title_hover',
                'label' => __('تایپوگرافی هاور عنوان', 'studiare'),
                'selector' => 'html {{WRAPPER}} .product-meta-info-list .meta-info-unit .value:hover',
            ]
        );

        $this->add_control(
            'color_title_hover',
            [
                'label' => __('رنگ هاور عنوان', 'studiare'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    'html {{WRAPPER}} .product-meta-info-list .meta-info-unit .value:hover' => 'color: {{VALUE}}',
                ]
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();
    }

    protected function render()
    {
        $prefix = '_studiare_';

        $default_settings = array(
            'product_id' => false,
        );

        $settings = wp_parse_args($this->get_settings_for_display(), $default_settings);

        Engine::setup_preview(array(), $settings['product_id']);

        echo '<div class="product-info-box stdProductHolder">';
        echo '<div class="product-meta-info-list">';
        foreach ($settings['all_meta'] as $item) {
            if ($item['select_meta'] == 'feture_group'):
                if (!empty(get_post_meta(get_the_ID(), $item['select_meta'], true))):
                    $this->stdCustomMeta();
                endif;
            endif;
            if (!empty(get_post_meta(get_the_ID(), $prefix . $item['select_meta'], true))):
                $value = get_post_meta(get_the_ID(), $prefix . $item['select_meta'], true);
                switch ($item['select_meta']) {
                    case 'course_percent':
                        echo '
                        <div class="progress-title">
                            <i class="' . $this->list_meta($item['select_meta'])['icon'] . '"></i> 
                             ' . $this->list_meta($item['select_meta'])['title'] . '
                             %' . $value . '
                            <div class="meter animate">
                                <span style="width: ' . $value . '%"><span></span></span>
                            </div>
                        </div>';
                        break;
                    case 'zero':
                        //Code...
                        break;
                    default:
                        echo '                
                        <div class="meta-info-unit">
                            <div class="icon"><i class="' . $this->list_meta($item['select_meta'])['icon'] . '"></i></div>
                            <div class="value">
                            ' . $this->meta_name($item) . '
                            ' . $value . '
                            </div>
                        </div>';
                }
            endif;
        }
        echo '</div>';
        echo '</div>';

        Engine::restore_preview($settings['product_id']);
    }

    public function stdCustomMeta()
    {
        $prefix = '_studiare_';
        $feature_entries = get_post_meta(get_the_ID(), 'feture_group', true);
        if ($feature_entries) {
            foreach ($feature_entries as $key => $entry) { ?>

                <div class="meta-info-unit">
                    <div class="icon"><i class="fal fa-check"></i></div>
                    <div class="value"><?php echo esc_html($entry[$prefix . 'feture_title']); ?> :
                        <span> <?php echo esc_html($entry[$prefix . 'feture_input']); ?></span></div>
                </div>
            <?php }
        }
    }

    public function meta_name($item)
    {
        if (empty($item['title'])):
            return $this->list_meta($item['select_meta'])['title'];
        else:
            return $item['title'];
        endif;
    }
}

Plugin::instance()->widgets_manager->register(new STD_Product_MetaList());
