<?php

namespace Engine\Modules\Layouts;
namespace Elementor;

use Elementor\Plugin;
use Elementor\Widget_Base;
use Engine\Engine;

if (!defined('ABSPATH')) {
    exit; // Direct access not allowed.
}


class STD_Product_Price extends Widget_Base
{

    public function get_name()
    {
        return 'std_product_price';
    }

    public function get_title()
    {
        return esc_html__('قیمت محصول', 'studiare');
    }

    public function get_icon()
    {
        return 'eicon-product-price';
    }

    public function get_categories()
    {
        return array('std-single-product-elements');
    }

    public function show_in_panel()
    {
        return Engine::is_layout_type('single_product');
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'section_title',
            array(
                'label' => esc_html__('قیمت محصول', 'studiare'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            )
        );

        $this->add_control(
			'style-price',
			array(
				'label'   => esc_html__( 'انتخاب استایل', 'studiare-core' ),
				'type'    => Controls_Manager::SELECT,
				'options' => array(
					'std-add-t-cart'      => esc_html__( 'استایل اول', 'studiare-core' ),
					'std-add-t-cart-2' => esc_html__( 'استایل دوم', 'studiare-core' ),
				),
				'default' => 'std-add-t-cart',
			)
		);

        $this->end_controls_section();
    }

    protected function render()
    {
        $default_settings = array(
            'product_id' => false,
        );

        $settings = wp_parse_args($this->get_settings_for_display(), $default_settings);

        Engine::setup_preview(array(), $settings['product_id']);
        global $product;
        $current_user = wp_get_current_user();
        $course_purchase = codebean_option('course_purchase');

        ?>

        <?php if (wc_customer_bought_product($current_user->user_email, $current_user->ID, $product->get_id()) && ($course_purchase)) : ?>
           
        <?php else : ?>
            <div class="<?php echo esc_attr( $settings['style-price'] ); ?>">
            <?php wc_get_template('single-product/price.php'); ?>
            </div>
        <?php endif ?>
        <?php
        Engine::restore_preview($settings['product_id']);
    }
}

Plugin::instance()->widgets_manager->register(new STD_Product_Price());
