<?php

namespace Engine\Modules\Layouts;

use Elementor\Group_Control_Typography;
use Elementor\Plugin;
use Elementor\Widget_Base;
use Engine\Engine;

if (!defined('ABSPATH')) {
    exit; // Direct access not allowed.
}


class STD_Product_Rate extends Widget_Base
{

    public function get_name()
    {
        return 'std_product_rate';
    }

    public function get_title()
    {
        return esc_html__('امتیاز محصول', 'studiare');
    }

    public function get_icon()
    {
        return 'eicon-rating';
    }

    public function get_categories()
    {
        return array('std-single-product-elements');
    }

    public function show_in_panel()
    {
        return Engine::is_layout_type('single_product');
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'section_title',
            array(
                'label' => esc_html__('امتیاز محصول', 'studiare'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            )
        );

        $this->add_control(
            'reviews_note',
            array(
                'type' => \Elementor\Controls_Manager::RAW_HTML,
                'raw' => esc_html__('این المان تنظیماتی ندارد :)', 'studiare'),
                'content_classes' => 'elementor-panel-alert elementor-panel-alert-info',
            )
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        Engine::setup_preview();
        global $product;
        ?>
        <div class="average-rating-sidebar stdProductRate">
            <div class="avareage-rating-inner">
                <div class="average-rating-number"><span class="title-rate">امتیاز</span>
                    <div class="schema-stars">
                    <span><?php $average = $product->get_average_rating();
                        echo esc_attr($average); ?></span>
                        <span class="title-rate">از</span>
                        <span><?php $rating_count = $product->get_rating_count();
                            echo esc_attr($rating_count); ?></span>
                        <span class="title-rate">رأی</span>
                    </div>
                </div>
                <div class="average-rating-stars">
                    <?php do_action('woocommerce_after_shop_loop_item_title'); ?>
                </div>

            </div>
        </div>
        <?php
        Engine::restore_preview();
    }
}

Plugin::instance()->widgets_manager->register(new STD_Product_Rate());
