<?php

namespace Engine\Modules\Layouts;

use Elementor\Group_Control_Typography;
use Elementor\Plugin;
use Elementor\Widget_Base;
use Engine\Engine;

if (!defined('ABSPATH')) {
    exit; // Direct access not allowed.
}


class STD_Product_Sharing extends Widget_Base
{

    public function get_name()
    {
        return 'std_product_sharing';
    }

    public function get_title()
    {
        return esc_html__('اشتراک گذاری محصول', 'studiare');
    }

    public function get_icon()
    {
        return 'eicon-share';
    }

    public function get_categories()
    {
        return array('std-single-product-elements');
    }

    public function show_in_panel()
    {
        return Engine::is_layout_type('single_product');
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'section_title',
            array(
                'label' => esc_html__('اشتراک گذاری محصول', 'studiare'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            )
        );
        $this->add_control(
            'reviews_note',
            array(
                'type' => \Elementor\Controls_Manager::RAW_HTML,
                'raw' => esc_html__('این المان تنظیماتی ندارد :)', 'studiare'),
                'content_classes' => 'elementor-panel-alert elementor-panel-alert-info',
            )
        );
        $this->end_controls_section();
    }

    protected function render()
    {
        Engine::setup_preview();
        echo '<div class="stdProductSharing">';
        ?>
        <div class="post-share-btn affix" data-spy="affix">
            <a href="https://telegram.me/share/url?url=<?php the_permalink() ?>&text=<?php the_title(); ?>"
               target="_blank"
               data-tooltip="اشتراک گذاری در تلگرام">
                <i class="fab fa-telegram"></i>
            </a>
            <a href="http://twitter.com/home/?status=<?php the_title(); ?> - <?php the_permalink(); ?>" target="_blank"
               data-tooltip="اشتراک گذاری در توئیتر">
                <i class="fab fa-twitter"></i>
            </a>
            <a href="http://www.facebook.com/sharer/sharer.php?s=100&p[url]=<?php echo urlencode(get_permalink()); ?>"
               target="_blank" data-tooltip="اشتراک گذاری در فیسبوک">
                <i class="fab fa-facebook"></i>
            </a>
            <a href="https://web.whatsapp.com/send?text=<?php the_permalink(); ?>" target="_blank"
               data-tooltip="اشتراک گذاری در واتساپ">
                <i class="fab fa-whatsapp"></i>
            </a>
        </div>
        <?php
        echo '</div>';
        Engine::restore_preview();
    }
}

Plugin::instance()->widgets_manager->register(new STD_Product_Sharing());
