<?php

namespace Engine\Modules\Layouts;

use Elementor\Group_Control_Typography;
use Elementor\Plugin;
use Elementor\Widget_Base;
use Engine\Engine;

if (!defined('ABSPATH')) {
    exit; // Direct access not allowed.
}


class STD_Product_ShortURL extends Widget_Base
{

    public function get_name()
    {
        return 'std_product_short_url';
    }

    public function get_title()
    {
        return esc_html__('لینک کوتاه محصول', 'studiare');
    }

    public function get_icon()
    {
        return 'eicon-url';
    }

    public function get_categories()
    {
        return array('std-single-product-elements');
    }

    public function show_in_panel()
    {
        return Engine::is_layout_type('single_product');
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'section_title',
            array(
                'label' => esc_html__('استایل لینک کوتاه محصول', 'studiare'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            )
        );

        $this->add_responsive_control(
            'title_alignment',
            [
                'label' => esc_html__('موقعیت', 'studiare'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'right' => [
                        'title' => esc_html__('Right', 'studiare'),
                        'icon' => 'eicon-text-align-right',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'studiare'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'left' => [
                        'title' => esc_html__('Left', 'studiare'),
                        'icon' => 'eicon-text-align-left',
                    ],
                ],
                'selectors' => [
                    'html {{WRAPPER}} input.short-url-link' => 'text-align: {{VALUE}};'
                ],
                'default' => 'right',
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $default_settings = array(
            'product_id' => false,
        );

        $settings = wp_parse_args($this->get_settings_for_display(), $default_settings);

        Engine::setup_preview(array(), $settings['product_id']);
        global $post;
        echo '<div class="short-url-box stdProductURl stdProductHolder">
				<input type="text" class="short-url-link" value="' . get_bloginfo('url') . '/?p=' . $post->ID . '" id="myInput">
			  </div>';
        Engine::restore_preview($settings['product_id']);
    }
}

Plugin::instance()->widgets_manager->register(new STD_Product_ShortURL());
