<?php

namespace Engine\Modules\Layouts;

use Elementor\Group_Control_Typography;
use Elementor\Plugin;
use Elementor\Widget_Base;
use Engine\Engine;

if (!defined('ABSPATH')) {
    exit; // Direct access not allowed.
}


class STD_Product_Tags extends Widget_Base
{

    public function get_name()
    {
        return 'std_product_tags';
    }

    public function get_title()
    {
        return esc_html__('برچسب ها', 'studiare');
    }

    public function get_icon()
    {
        return 'eicon-tags';
    }

    public function get_categories()
    {
        return array('std-single-product-elements');
    }

    public function show_in_panel()
    {
        return Engine::is_layout_type('single_product');
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'section_title',
            array(
                'label' => esc_html__('استایل کلی باکس برچسب ها', 'studiare'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            )
        );

        $this->add_responsive_control(
            'title_alignment',
            [
                'label' => esc_html__('موقعیت', 'studiare'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'right' => [
                        'title' => esc_html__('Right', 'studiare'),
                        'icon' => 'eicon-text-align-right',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'studiare'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'left' => [
                        'title' => esc_html__('Left', 'studiare'),
                        'icon' => 'eicon-text-align-left',
                    ],
                ],
                'selectors' => [
                    'html {{WRAPPER}} .product-single-content .tagged_as' => 'text-align: {{VALUE}};'
                ],
                'default' => 'right',
            ]
        );

        $this->start_controls_tabs(
            'style_box_holder_tabs'
        );

        $this->start_controls_tab(
            'style_box_normal_tab',
            [
                'label' => esc_html__('عادی', 'studiare'),
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'bg_box',
                'label' => esc_html__('پس زمینه', 'studiare'),
                'types' => ['classic', 'gradient'],
                'selector' => 'html {{WRAPPER}} .product-single-content',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'border_box',
                'label' => esc_html__('کادر دور', 'studiare'),
                'selector' => 'html {{WRAPPER}} .product-single-content',
            ]
        );

        $this->add_responsive_control(
            'border_radius_box',
            [
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'label' => esc_html__('گردی دور', 'studiare'),
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    'html {{WRAPPER}} .product-single-content' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'box_padding',
            [
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'label' => esc_html__('فاصله داخلی', 'studiare'),
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    'html {{WRAPPER}} .product-single-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadow',
                'label' => __('سایه', 'studiare'),
                'selector' => 'html {{WRAPPER}} .product-single-content',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'style_box_hover_tab',
            [
                'label' => esc_html__('هاور', 'studiare'),
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'bg_box_hover',
                'label' => esc_html__('هاور پس زمینه', 'studiare'),
                'types' => ['classic', 'gradient'],
                'selector' => 'html {{WRAPPER}} .product-single-content:hover',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'border_box_hover',
                'label' => esc_html__('هاور کادر دور', 'studiare'),
                'selector' => 'html {{WRAPPER}} .product-single-content:hover',
            ]
        );

        $this->add_responsive_control(
            'border_radius_box_hover',
            [
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'label' => esc_html__('هاور گردی دور', 'studiare'),
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    'html {{WRAPPER}} .product-single-content:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'box_padding_hover',
            [
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'label' => esc_html__('هاور فاصله داخلی', 'studiare'),
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    'html {{WRAPPER}} .product-single-content:hover' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadow_hover',
                'label' => __('هاور سایه', 'studiare'),
                'selector' => 'html {{WRAPPER}} .product-single-content:hover',
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();

        $this->start_controls_section(
            'style_txt',
            array(
                'label' => esc_html__('استایل متن ها', 'studiare'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            )
        );

        $this->start_controls_tabs(
            'style_holder_tabs'
        );

        $this->start_controls_tab(
            'style_normal_tab',
            [
                'label' => esc_html__('عادی', 'studiare'),
            ]
        );

        $this->add_control(
            'color_icon',
            [
                'label' => __('رنگ آیکون', 'studiare'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    'html {{WRAPPER}} .product-single-content .tagged_as .fal' => 'color: {{VALUE}}',
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'type_title',
                'label' => __('تایپوگرافی متن اصلی', 'studiare'),
                'selector' => 'html {{WRAPPER}} .product-single-content .tagged_as',
            ]
        );

        $this->add_control(
            'color_txt_title',
            [
                'label' => __('رنگ متن اصلی', 'studiare'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    'html {{WRAPPER}} .product-single-content .tagged_as' => 'color: {{VALUE}}',
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'type_item',
                'label' => __('تایپوگرافی آیتم ها', 'studiare'),
                'selector' => 'html {{WRAPPER}} .product-single-content .tagged_as a',
            ]
        );

        $this->add_control(
            'color_item',
            [
                'label' => __('رنگ متن آیتم ها', 'studiare'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    'html {{WRAPPER}} .product-single-content .tagged_as a' => 'color: {{VALUE}} !important;',
                ]
            ]
        );

        $this->add_control(
            'bg_item',
            [
                'label' => __('رنگ پس زمینه آیتم ها', 'studiare'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    'html {{WRAPPER}} .product-single-content .tagged_as a' => 'background: {{VALUE}};',
                ]
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'style_hover_tab',
            [
                'label' => esc_html__('هاور', 'studiare'),
            ]
        );

        $this->add_control(
            'color_icon_hover',
            [
                'label' => __('رنگ هاور آیکون', 'studiare'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    'html {{WRAPPER}} .product-single-content .tagged_as:hover .fal' => 'color: {{VALUE}}',
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'type_title_hover',
                'label' => __('تایپوگرافی هاور متن اصلی', 'studiare'),
                'selector' => 'html {{WRAPPER}} .product-single-content .tagged_as:hover',
            ]
        );

        $this->add_control(
            'color_txt_title_hover',
            [
                'label' => __('رنگ هاور متن اصلی', 'studiare'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    'html {{WRAPPER}} .product-single-content .tagged_as:hover' => 'color: {{VALUE}}',
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'type_item_hover',
                'label' => __('تایپوگرافی هاور آیتم ها', 'studiare'),
                'selector' => 'html {{WRAPPER}} .product-single-content .tagged_as a:hover',
            ]
        );

        $this->add_control(
            'color_item_hover',
            [
                'label' => __('رنگ هاور متن آیتم ها', 'studiare'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    'html {{WRAPPER}} .product-single-content .tagged_as a:hover' => 'color: {{VALUE}} !important;',
                ]
            ]
        );

        $this->add_control(
            'bg_item_hover',
            [
                'label' => __('رنگ هاور پس زمینه آیتم ها', 'studiare'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    'html {{WRAPPER}} .product-single-content .tagged_as a:hover' => 'background: {{VALUE}} !important;',
                ]
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();
    }

    protected function render()
    {
        Engine::setup_preview();
        global $product;
        echo wc_get_product_tag_list($product->get_id(), '  ', '<div class="product-single-content"><span class="tagged_as"><i class="fal fa-tags"></i>' . _n('Tag:', 'Tags:', count($product->get_tag_ids()), 'woocommerce') . ' ', '</span></div>');
        Engine::restore_preview();
    }
}

Plugin::instance()->widgets_manager->register(new STD_Product_Tags());
