<?php

namespace Engine\Modules\Layouts;

use Elementor\Group_Control_Typography;
use Elementor\Plugin;
use Elementor\Widget_Base;
use Engine\Engine;

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Direct access not allowed.
}


class STD_Product_Title extends Widget_Base {

    public function get_name() {
        return 'std_single_product_title';
    }

    public function get_title() {
        return esc_html__( 'عنوان محصول', 'studiare' );
    }

    public function get_icon() {
        return 'eicon-t-letter';
    }

    public function get_categories() {
        return array( 'std-single-product-elements' );
    }

    public function show_in_panel() {
        return Engine::is_layout_type( 'single_product' );
    }

    protected function register_controls() {

        $this->start_controls_section(
            'section_title',
            array(
                'label' => esc_html__( 'استایل عنوان محصول', 'studiare' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            )
        );

        $this->add_responsive_control(
            'title_alignment',
            [
                'label' => esc_html__('موقعیت', 'studiare'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'right' => [
                        'title' => esc_html__('Right', 'studiare'),
                        'icon' => 'eicon-text-align-right',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'studiare'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'left' => [
                        'title' => esc_html__('Left', 'studiare'),
                        'icon' => 'eicon-text-align-left',
                    ],
                ],
                'selectors' => [
                    'html {{WRAPPER}} .product_title' => 'text-align: {{VALUE}};'
                ],
                'default' => 'right',
            ]
        );

        $this->start_controls_tabs(
            'style_box_holder_tabs'
        );

        $this->start_controls_tab(
            'style_box_normal_tab',
            [
                'label' => esc_html__('عادی', 'studiare'),
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'type_title',
                'label' => __('تایپوگرافی عنوان', 'studiare'),
                'selector' => 'html {{WRAPPER}} .product_title',
            ]
        );

        $this->add_control(
            'color_txt_title',
            [
                'label' => __('رنگ عنوان', 'studiare'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    'html {{WRAPPER}} .product_title' => 'color: {{VALUE}}',
                ]
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'style_box_hover_tab',
            [
                'label' => esc_html__('هاور', 'studiare'),
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'type_title_hover',
                'label' => __('تایپوگرافی هاور عنوان', 'studiare'),
                'selector' => 'html {{WRAPPER}} .product_title:hover',
            ]
        );

        $this->add_control(
            'color_txt_title_hover',
            [
                'label' => __('رنگ هاور عنوان', 'studiare'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    'html {{WRAPPER}} .product_title:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();
    }

    protected function render() {
        $default_settings = array(
            'product_id' => false,
        );

        $settings = wp_parse_args( $this->get_settings_for_display(), $default_settings );

        Engine::setup_preview( array(), $settings['product_id'] );
        wc_get_template( 'single-product/title.php' );
        Engine::restore_preview( $settings['product_id'] );
    }
}

Plugin::instance()->widgets_manager->register( new STD_Product_Title() );
