<?php

namespace Engine\Modules\Layouts;

use Elementor\Group_Control_Typography;
use Elementor\Plugin;
use Elementor\Widget_Base;
use Engine\Engine;

if (!defined('ABSPATH')) {
    exit; // Direct access not allowed.
}


class STD_Product_View extends Widget_Base
{

    public function get_name()
    {
        return 'std_product_view';
    }

    public function get_title()
    {
        return esc_html__('تعداد بازدید', 'studiare');
    }

    public function get_icon()
    {
        return 'eicon-preview-medium';
    }

    public function get_categories()
    {
        return array('std-single-product-elements');
    }

    public function show_in_panel()
    {
        return Engine::is_layout_type('single_product');
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'section_title',
            array(
                'label' => esc_html__('استایل تعداد بازدید', 'studiare'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            )
        );

        $this->start_controls_tabs(
            'style_box_holder_tabs'
        );

        $this->start_controls_tab(
            'style_box_normal_tab',
            [
                'label' => esc_html__('عادی', 'studiare'),
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'type_title',
                'label' => __('تایپوگرافی متن', 'studiare'),
                'selector' => 'html {{WRAPPER}} .stdProductView .product-views',
            ]
        );

        $this->add_control(
            'color_txt',
            [
                'label' => __('رنگ متن', 'studiare'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    'html {{WRAPPER}} .stdProductView .product-views' => 'color: {{VALUE}}',
                ]
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'style_box_hover_tab',
            [
                'label' => esc_html__('هاور', 'studiare'),
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'type_title_hover',
                'label' => __('تایپوگرافی هاور متن', 'studiare'),
                'selector' => 'html {{WRAPPER}} .stdProductView .product-views:hover',
            ]
        );

        $this->add_control(
            'color_txt_hover',
            [
                'label' => __('رنگ هاور متن', 'studiare'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    'html {{WRAPPER}} .stdProductView .product-views:hover' => 'color: {{VALUE}}',
                ]
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();
    }

    protected function render()
    {
        $default_settings = array(
            'product_id' => false,
        );

        $settings = wp_parse_args($this->get_settings_for_display(), $default_settings);

        Engine::setup_preview(array(), $settings['product_id']);
        global $post;
        $visitor_count = get_post_meta($post->ID, '_post_views_count', true);
        if ($visitor_count == '') {
            $visitor_count = 0;
        }
        if ($visitor_count >= 1000) {
            $visitor_count = round(($visitor_count / 1000), 2);
            $visitor_count = $visitor_count . 'k';
        }
        echo '<div class="std-box-view stdProductView">';
        echo '<span class="product-views">';
        echo '<i class="fal fa-eye"></i> ';
        echo esc_attr($visitor_count);
        echo ' بازدید';
        echo '</span>';
        echo '</div>';
        Engine::restore_preview($settings['product_id']);
    }
}

Plugin::instance()->widgets_manager->register(new STD_Product_View());
