<?php

namespace Engine\Modules\Layouts;

use Elementor\Group_Control_Typography;
use Elementor\Plugin;
use Elementor\Widget_Base;
use Engine\Engine;

if (!defined('ABSPATH')) {
    exit; // Direct access not allowed.
}


class STD_Related_Product extends Widget_Base
{

    public function get_name()
    {
        return 'std_related_product';
    }

    public function get_title()
    {
        return esc_html__('محصولات مرتبط', 'studiare');
    }

    public function get_icon()
    {
        return 'eicon-product-related';
    }

    public function get_categories()
    {
        return array('std-single-product-elements');
    }

    public function show_in_panel()
    {
        return Engine::is_layout_type('single_product');
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'section_title',
            array(
                'label' => esc_html__('استایل محصولات مرتبط', 'studiare'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            )
        );

        $this->start_controls_tabs(
            'style_box_holder_tabs'
        );

        $this->start_controls_tab(
            'style_box_norma0l_tab',
            [
                'label' => esc_html__('عادی', 'studiare'),
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'type_title_box',
                'label' => __('تایپوگرافی عنوان باکس', 'studiare'),
                'selector' => 'html {{WRAPPER}} .product-reviews .product-review-title .inner',
            ]
        );

        $this->add_control(
            'color_title_box',
            [
                'label' => __('رنگ عنوان باکس', 'studiare'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    'html {{WRAPPER}} .product-reviews .product-review-title .inner' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'color_bottom_title_box',
            [
                'label' => __('رنگ خط پایین عنوان باکس', 'studiare'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    'html {{WRAPPER}} .product-reviews .product-review-title .inner:after' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'type_title_product',
                'label' => __('تایپوگرافی عنوان محصول', 'studiare'),
                'selector' => 'html {{WRAPPER}} .products .course-item .course-item-inner .course-content-holder .course-content-main .course-title a',
            ]
        );

        $this->add_control(
            'color_title_product',
            [
                'label' => __('رنگ عنوان محصول', 'studiare'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    'html {{WRAPPER}} .products .course-item .course-item-inner .course-content-holder .course-content-main .course-title a' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'type_desc_product',
                'label' => __('تایپوگرافی توضیحات محصول', 'studiare'),
                'selector' => 'html {{WRAPPER}} .products .course-item .course-item-inner .course-content-holder .course-content-main .course-description p',
            ]
        );

        $this->add_control(
            'color_desc_product',
            [
                'label' => __('رنگ توضیحات محصول', 'studiare'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    'html {{WRAPPER}} .products .course-item .course-item-inner .course-content-holder .course-content-main .course-description p' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'style_box_hover_tab',
            [
                'label' => esc_html__('هاور', 'studiare'),
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'type_title_box_hover',
                'label' => __('تایپوگرافی هاور عنوان باکس', 'studiare'),
                'selector' => 'html {{WRAPPER}} .product-reviews .product-review-title:hover .inner',
            ]
        );

        $this->add_control(
            'color_title_box_hover',
            [
                'label' => __('رنگ عنوان باکس', 'studiare'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    'html {{WRAPPER}} .product-reviews .product-review-title:hover .inner' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'color_bottom_title_box_hover',
            [
                'label' => __('رنگ هاور خط پایین عنوان باکس', 'studiare'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    'html {{WRAPPER}} .product-reviews .product-review-title:hover .inner:after' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'type_title_product_hover',
                'label' => __('تایپوگرافی هاور عنوان محصول', 'studiare'),
                'selector' => 'html {{WRAPPER}} .products .course-item .course-item-inner .course-content-holder .course-content-main .course-title:hover a',
            ]
        );

        $this->add_control(
            'color_title_product_hover',
            [
                'label' => __('رنگ هاور عنوان محصول', 'studiare'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    'html {{WRAPPER}} .products .course-item .course-item-inner .course-content-holder .course-content-main .course-title:hover a' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'type_desc_product_hover',
                'label' => __('تایپوگرافی هاور توضیحات محصول', 'studiare'),
                'selector' => 'html {{WRAPPER}} .products .course-item .course-item-inner .course-content-holder .course-content-main .course-description:hover p',
            ]
        );

        $this->add_control(
            'color_desc_product_hover',
            [
                'label' => __('رنگ هاور توضیحات محصول', 'studiare'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    'html {{WRAPPER}} .products .course-item .course-item-inner .course-content-holder .course-content-main .course-description:hover p' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();
    }

    protected function render()
    {
        Engine::setup_preview();
        get_template_part( '/inc/templates/woocommerce/related' );
        Engine::restore_preview();
    }
}

Plugin::instance()->widgets_manager->register(new STD_Related_Product());
