<?php

namespace Engine\Modules\Layouts;

use Elementor\Group_Control_Typography;
use Elementor\Plugin;
use Elementor\Widget_Base;
use Engine\Engine;

if (!defined('ABSPATH')) {
    exit; // Direct access not allowed.
}


class STD_Product_Teacher extends Widget_Base
{

    public function get_name()
    {
        return 'std_product_teacher';
    }

    public function get_title()
    {
        return esc_html__('مدرس دوره', 'studiare');
    }

    public function get_icon()
    {
        return 'eicon-user-circle-o';
    }

    public function get_categories()
    {
        return array('std-single-product-elements');
    }

    public function show_in_panel()
    {
        return Engine::is_layout_type('single_product');
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'section_title',
            array(
                'label' => esc_html__('مدرس دوره', 'studiare'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            )
        );

        $this->add_control(
            'border-inner',
            [
               'label' => __( 'حذف حاشیه اطراف جعبه', 'studiare-core' ),
               'type' => \Elementor\Controls_Manager::SWITCHER,
               'default' => 'no',
   
            ]
         );

        $this->end_controls_section();
    }

    protected function render()
    {
        Engine::setup_preview();

        $settings = $this->get_settings_for_display();
        $prefix = '_studiare_';
        $teacher_id = get_post_meta(get_the_ID(), $prefix . 'course_teacher', true);
        $teacher_2_id = get_post_meta(get_the_ID(), $prefix . 'course_teacher_2', true);
        $teacher_post = get_post($teacher_id);
        $teacher_job_title = get_post_meta($teacher_id, $prefix . 'teacher_job_title', true);
        ?>


        <div class="course-teacher-details <?php if (  'yes' == $settings['border-inner'] ) { echo 'less-border'; } ?>">
            <div class="top-part">
                <?php $teacher_image = wp_get_attachment_image_src(get_post_thumbnail_id($teacher_id), 'img-120-120', false); ?>
                <?php if (!empty($teacher_image[0])): ?>
                    <a href="<?php echo esc_url(get_permalink($teacher_post)); ?>">
                        <img class="img-fluid" src="<?php echo esc_url($teacher_image[0]); ?>" alt="<?php echo esc_attr(get_the_title($teacher_id)); ?>"></a>
                <?php endif; ?>
                <div class="name">
                    <a href="<?php echo esc_url(get_permalink($teacher_post)); ?>" class="btn-link">
                        <h6><?php echo esc_attr(get_the_title($teacher_id)); ?></h6>
                    </a>
                    <?php if (!empty($teacher_job_title)): ?>
                        <span class="job-title"><?php echo esc_attr($teacher_job_title); ?></span>
                    <?php endif; ?>
                </div>
            </div>
            <div class="content">
                <p><?php echo esc_attr($teacher_post->post_excerpt); ?></p>
            </div>


            <?php if (!empty($teacher_2_id) && $teacher_2_id != 'no-teacher') : ?>
                <?php
                $teacher_post = get_post($teacher_2_id);
                $teacher_job_title = get_post_meta($teacher_2_id, $prefix . 'teacher_job_title', true);
                ?>
                <div class="top-part">
                    <?php $teacher_image = wp_get_attachment_image_src(get_post_thumbnail_id($teacher_2_id), 'img-120-120', false); ?>
                    <?php if (!empty($teacher_image[0])): ?>
                        <a href="<?php echo esc_url(get_permalink($teacher_post)); ?>">
                            <img class="img-fluid" src="<?php echo esc_url($teacher_image[0]); ?>" alt="<?php echo esc_attr(get_the_title($teacher_id)); ?>"></a>
                    <?php endif; ?>
                    <div class="name">
                        <a href="<?php echo esc_url(get_permalink($teacher_post)); ?>" class="btn-link">
                            <h6><?php echo esc_attr(get_the_title($teacher_2_id)); ?></h6></a>
                        <?php if (!empty($teacher_job_title)): ?>
                            <span class="job-title"><?php echo esc_attr($teacher_job_title); ?></span>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="content">
                    <p><?php echo esc_attr($teacher_post->post_excerpt); ?></p>
                </div>

            <?php endif; ?>
        </div>
        <?php
        Engine::restore_preview();
    }
}

Plugin::instance()->widgets_manager->register(new STD_Product_Teacher());
