<?php

namespace Engine\Modules\Layouts;

use Elementor\Group_Control_Typography;
use Elementor\Plugin;
use Elementor\Widget_Base;
use Engine\Engine;

if (!defined('ABSPATH')) {
    exit; // Direct access not allowed.
}

class STD_Video_Play extends Widget_Base
{

    public function get_name()
    {
        return 'std_video_product';
    }

    public function get_title()
    {
        return esc_html__('ویدئوی معرفی دوره', 'studiare');
    }

    public function get_icon()
    {
        return 'eicon-youtube';
    }

    public function get_categories()
    {
        return array('std-single-product-elements');
    }

    public function show_in_panel()
    {
        return Engine::is_layout_type('single_product');
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'section_title',
            array(
                'label' => esc_html__('ویدئوی معرفی دوره', 'studiare'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            )
        );

        $this->add_responsive_control(
            'border_radius_video',
            [
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'label' => esc_html__('گردی دور ویدیو', 'studiare'),
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    'html {{WRAPPER}} .stdCourseVideo .mejs-video ,html {{WRAPPER}} .stdCourseVideo img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $prefix = '_studiare_';

        $default_settings = array(
            'product_id' => false,
        );

        $settings = wp_parse_args($this->get_settings_for_display(), $default_settings);

        Engine::setup_preview(array(), $settings['product_id']);

        $course_disable_image = get_post_meta(get_the_ID(), $prefix . 'course_disable_image', true);
        $course_video = get_post_meta(get_the_ID(), $prefix . 'course_video', true);
        $poster_video_coures = get_post_meta(get_the_ID(), $prefix . 'poster_video_coures', true);

        echo '<div class="course-single-gallery stdCourseVideo">';

        if ($course_disable_image) :
            $attr = array(
                'mp4' => $course_video,
                'poster' => $poster_video_coures,
                'preload' => 'none',
                'width' => '1200',
                'height' => '700'
            );
            echo wp_video_shortcode($attr);

        else:
            $this->std_gallery_img();
        endif;

        echo '</div>';

        Engine::restore_preview($settings['product_id']);
    }

    public function std_gallery_img()
    {
        if (!function_exists('wc_get_gallery_image_html')) {
            return;
        }

        global $post, $product;

        $prefix = '_studiare_';

        $course_video = get_post_meta(get_the_ID(), $prefix . 'course_video', true);

        $post_thumbnail_id = get_post_thumbnail_id($post->ID);
        $full_size_image = wp_get_attachment_image_src($post_thumbnail_id, 'full');
        $image_title = get_post_field('post_excerpt', $post_thumbnail_id);
        $wrapper_classes = apply_filters('woocommerce_single_product_image_gallery_classes', array(
            'woocommerce-product-gallery',
        ));
        ?>
        <div class="<?php echo esc_attr(implode(' ', array_map('sanitize_html_class', $wrapper_classes))); ?>"
             style="transition: opacity .25s ease-in-out;">
            <div class="product-image-wrapper">
                <?php

                $attributes = array(
                    'title' => $image_title,
                    'data-src' => $full_size_image[0]
                );

                if (has_post_thumbnail()) {
                    $html = get_the_post_thumbnail($post->ID, 'full', $attributes);
                } else {
                    $html = sprintf('<img src="%s" alt="%s" data-src="%s" data-large_image="%s" data-large_image_width="800" data-large_image_height="600" class="attachment-shop_single size-shop_single wp-post-image" />', esc_url(wc_placeholder_img_src()), esc_html__('Awaiting product image', 'studiare'), esc_url(wc_placeholder_img_src()), esc_url(wc_placeholder_img_src()));
                }

                echo apply_filters('woocommerce_single_product_image_thumbnail_html', $html, $post_thumbnail_id); ?>

                <?php if ($course_video) : ?>
                    <div class="video-button">
                        <a data-post-id="<?php echo get_the_ID(); ?>" href="<?php echo esc_url($course_video); ?>"
                           class="cdb-video-icon video-thumbnail"><i class="fal fa-play"></i></a>
                    </div>
                <?php endif; ?>

            </div>
        </div>
        <?php
    }
}

Plugin::instance()->widgets_manager->register(new STD_Video_Play());
