<?php
/**
 * Form template.
 *
 *
 * @var array $layout_types Layout types.
 * @var Engine_Admin $admin        Admin instance.
 */

use Engine\Modules\Layouts\Engine_Admin;

$layout_default_name = 'نام طراحی جدید';
$current_tab         = isset( $_GET['std_layout_type_tab'] ) ? $_GET['std_layout_type_tab'] : 'all';  // phpcs:ignore

if ( 'single_product' === $current_tab ) {
	$layout_default_name = 'Single product layout';
}

$wrapper_classes = ' std-layout-type-' . $current_tab;
?>
<form>
	<div class="std-layout-fields<?php echo esc_attr( $wrapper_classes ); ?>">
		<div class="std-layout-field std-layout-type-select">
			<label for="std_layout_type">
				<?php esc_html_e( 'نوع صفحه', 'studiare' ); ?>
			</label>
			<select class="std-layout-type" id="std_layout_type" name="std_layout_type" required>
				<option value="">
					<?php esc_html_e( 'انتخاب نمایید...', 'studiare' ); ?>
				</option>
				<?php foreach ( $layout_types as $key => $label ) : ?>
					<?php
					$current_tab = isset( $_GET['std_layout_type_tab'] ) ? $_GET['std_layout_type_tab'] : ''; // phpcs:ignore

					?>
					<option value="<?php echo esc_attr( $key ); ?>" <?php selected( $current_tab, $key ); ?>>
						<?php echo esc_html( $label ); ?>
					</option>
				<?php endforeach; ?>
			</select>
		</div>

		<div class="std-layout-field">
			<label for="std_layout_name">
				<?php esc_html_e( 'نام طراحی', 'studiare' ); ?>
			</label>
			<input class="std-layout-name" id="std_layout_name" name="std_layout_name" type="text" placeholder="<?php esc_html_e( 'نام طراحی را وارد نمایید', 'studiare' ); ?>" required value="<?php echo esc_attr( $layout_default_name ); ?>">
		</div>
	</div>

	<div class="std-layout-conditions">
		<label class="std-layout-conditions-title">
			<?php esc_html_e( 'شرط ها', 'studiare' ); ?>
		</label>

		<a href="javascript:void(0);" class="std-layout-condition-add std-hidden">
			<?php esc_html_e( 'افزودن شرط', 'studiare' ); ?>
		</a>
	</div>

	<?php $admin->get_predefined_layouts(); ?>
	<div class="std-popup-actions std-layout-submit-wrap">
		<button class="std-disabled std-layout-submit" type="submit">
			<?php esc_html_e( 'ایجاد طراحی', 'studiare' ); ?>
		</button>
	</div>
</form>
