<?php
/**
 * Edit conditions template.
 *
 *
 * @var Engine_Admin  $admin      Admin instance.
 * @var string $type       Layout type.
 * @var array  $conditions Conditions.
 * @var int    $post_id    Post id.
 */

use Engine\Modules\Layouts\Engine_Admin;

$conditions = $conditions ? wp_json_encode( $conditions, JSON_HEX_APOS ) : '';

ob_start();
?>
<div class="std-layout-conditions stdLayoutConditionsHolder" data-type="<?php echo esc_attr( $type ); ?>" data-conditions='<?php echo $conditions; ?>' data-id="<?php echo esc_attr( $post_id ); ?>">
	<a href="javascript:void(0);" class="std-layout-conditions-edit-add std-hidden">
		<?php esc_html_e( 'افزودن شرط', 'studiare' ); ?>
	</a>

	<div class="std-popup-actions std-layout-submit-wrap">
		<a href="javascript:void(0);" class="std-layout-conditions-edit-save std-hidden">
			<?php esc_html_e( 'ذخیره شرط ها', 'studiare' ); ?>
		</a>
	</div>

</div>
<?php
$content = ob_get_clean();

$admin->get_template(
	'popup',
	array(
		'btn_text'    => esc_html__( 'ویرایش شرط ها', 'studiare' ),
		'btn_classes' => ' std-layout-conditions-edit',
		'title_text'  => esc_html__( 'ویرایش شرط ها', 'studiare' ),
		'content'     => $content,
	)
);
