<?php
/**
 * Popup template.
 *
 *
 * @var string $btn_text     Button text.
 * @var string $btn_classes  Button classes.
 * @var string $title_text   Title text.
 * @var string $content      Content.
 */

$btn_classes = isset( $btn_classes ) ? $btn_classes : '';

wp_enqueue_style( 'std-admin-page-layouts', STUDIARE_THEMEASSETS . 'css/page-layouts.css', array() );
?>
<div class="std-popup-holder">
	<div class="std-popup-overlay"></div>
	<?php if ( $btn_text ) : ?>
		<a href="javascript:void(0);" class="std-popup-opener <?php echo esc_attr( $btn_classes ); ?>">
			<?php echo esc_html( $btn_text ); ?>
		</a>
	<?php endif; ?>

	<div class="std-popup std-theme-style">
		<div class="std-popup-inner">
			<div class="std-popup-header">
				<div class="std-popup-title">
					<?php echo esc_html( $title_text ); ?>
				</div>

				<a href="javascript:void(0);" class="std-popup-close std-i-close">
					<?php esc_html_e( 'Close', 'studiare' ); ?>
				</a>
			</div>

			<div class="std-popup-content">
				<div class="std-notices-wrapper std-layout-popup-notices"></div>

				<?php echo $content; // phpcs:ignore ?>

                <div class="lds-roller"><div></div><div></div><div></div><div></div><div></div><div></div><div></div><div></div></div>

            </div>
		</div>
	</div>
</div>
