<?php
/**
 * Predefined layouts template.
 *
 *
 * @var array $layouts Layouts.
 */

?>
<?php foreach ( $layouts as $layout_type => $values ) : ?>
	<div class="std-layout-predefined-layouts std-images-set std-hidden" data-type="<?php echo esc_attr( $layout_type ); ?>">
		<label><?php esc_html_e( 'دموهای آماده', 'studiare' ); ?></label>
		<div class="std-btns-set">
		
			<?php foreach ( $values as $layout => $data ) : ?>
				<div class="std-layout-predefined-layout std-set-item std-set-btn-img" data-name="<?php echo esc_attr( $layout ); ?>">
					<img src="<?php echo esc_url( STUDIARE_THEMEURL . 'inc/engine/demo/' . $layout_type . '/' . $layout . '/preview.jpg' ); ?>">
					<?php if ( ! empty( $data['url'] ) ) : ?>
						<div class="std-import-preview-wrap">
							<a href="<?php echo esc_url( $data['url'] ); ?>" class="std-btn std-color-white std-import-item-preview std-i-view" target="_blank">
								<?php esc_html_e( 'پیش نمایش زنده', 'studiare' ); ?>
							</a>
						</div>
					<?php endif; ?>
				</div>	
			<?php endforeach; ?>
		</div>
	</div>
<?php endforeach; ?>
